package gov.va.med.mhv.admin.model;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name = "SMS_USER_MHV_VW")
public class SMSUserView implements Serializable {

	private static final long serialVersionUID = -1865602310865397317L;

	@Id
	@Column(name = "USER_ID")
	// @GeneratedValue(strategy=GenerationType.AUTO)
	private Long userId;

	@Column(name = "EXTERNAL_USER_NAME")
	private String externalUserName;

	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "LAST_LOGIN")
	private Date lastLoginDate;

	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "CURRENT_LOGIN")
	private Date currentLoginDate;

	public Long getUserId() {
		return userId;
	}

	public void setUserId(Long userId) {
		this.userId = userId;
	}

	public String getExternalUserName() {
		return externalUserName;
	}

	public void setExternalUserName(String externalUserName) {
		this.externalUserName = externalUserName;
	}

	public Date getLastLoginDate() {
		return lastLoginDate;
	}

	public void setLastLoginDate(Date lastLoginDate) {
		this.lastLoginDate = lastLoginDate;
	}

	public Date getCurrentLoginDate() {
		return currentLoginDate;
	}

	public void setCurrentLoginDate(Date currentLoginDate) {
		this.currentLoginDate = currentLoginDate;
	}

}
